﻿IF EXISTS(SELECT * FROM sysobjects WHERE type = 'TR' AND name = 'VX_TR_Stratum')
BEGIN
  DROP TRIGGER VX_TR_Stratum
END
GO
CREATE TRIGGER [dbo].[VX_TR_Stratum]
   ON  [dbo].[Stratum]
   AFTER INSERT, DELETE, UPDATE
AS 
BEGIN
  -- SET NOCOUNT ON added to prevent extra result sets from
  -- interfering with SELECT statements.
  SET NOCOUNT ON;

  UPDATE Quota
  SET QtOnLine = CASE WHEN QtOnLine + ISNULL(inserted.IncrementValue, 0) - ISNULL(deleted.IncrementValue, 0) >= 0 THEN QtOnLine + ISNULL(inserted.IncrementValue, 0) - ISNULL(deleted.IncrementValue, 0) ELSE 0 END
  FROM Quota
  
  INNER JOIN
  (
      inserted FULL OUTER JOIN
      deleted ON inserted.StrStratum = deleted.StrStratum
  )
  ON QtQuotaID = COALESCE(inserted.StrQuotaID, deleted.StrQuotaID) --Use QuotaID since it is the PK (not StrStratum)
  WHERE (ISNULL(inserted.IncrementValue, 0) - ISNULL(deleted.IncrementValue, 0)) <> 0 --No update if Delta = 0
END
GO